; test operations on resource pool

; tests of specific named gimp-brush-delete etc. are elsewhere
; This tests the generic methods named like gimp-resource-<op>


; !!! Using v3 binding, which we restore to v2 at the end of this file
; since subsequent test scripts expect v2
(script-fu-use-v3)



; Since 3.0rc2 resource-get-by-name is private to libgimp

; setup
(define systemFont (gimp-font-get-by-name "Sans-serif"))
(define systemBrush (gimp-brush-get-by-name "2. Star"))



(test! "<resource> get by name")

; get-by-name, which is generic and takes a "resource type name"

; get-by-name on non-existent name returns C NULL i.e. invalid ID
;(assert `(= (gimp-resource-get-by-name "GimpBrush" "Agate")
;            -1))

; each of the specific get-by-name returns C NULL i.e. invalid ID
; on invalid name
(assert `(= (gimp-brush-get-by-name    "Agate") -1))
(assert `(= (gimp-font-get-by-name     "Agate") -1))
(assert `(= (gimp-gradient-get-by-name "Agate") -1))
(assert `(= (gimp-palette-get-by-name  "Agate") -1))
(assert `(= (gimp-pattern-get-by-name  "Agate") -1))



; get-by-name on invalid type name returns error
; FIXME throws critical but does not return an error, returns NULL i.e. ID 0
; Low priority to fix, it only happens during development of a plugin.
; (assert-error `(gimp-resource-get-by-name "FooType" "Agate")
;             "Error")

; get-by-name on existent name returns valid positive ID
;(assert `(> (gimp-resource-get-by-name "GimpFont" "Sans-serif")
;            0))

(assert `(> (gimp-brush-get-by-name    "2. Star")      0))
(assert `(> (gimp-font-get-by-name     "Sans-serif")   0))
(assert `(> (gimp-gradient-get-by-name "Default")      0))
(assert `(> (gimp-palette-get-by-name  "Default")      0))
(assert `(> (gimp-pattern-get-by-name  "Maple Leaves") 0))



(test! "ops on system resources")

; operations outlawed on a system resource
; i.e. one not created by script or installed by user

; Can't delete system font
(assert-error `(gimp-resource-delete ,systemFont)
              "Procedure execution of gimp-resource-delete failed")

; Can't rename system font
(assert-error `(gimp-resource-rename ,systemFont "newName")
              "Procedure execution of gimp-resource-rename failed")
              ; on invalid input arguments: Resource 'Sans-serif' is not renamable

; Can't duplicate a system font
; ??? Why are fonts different from brush re duplication?
(assert-error `(gimp-resource-duplicate ,systemFont)
              "Procedure execution of gimp-resource-duplicate failed")



(test! "resource duplicate, rename, delete")

; Can duplicate a system brush
(define duplicatedSystemBrush (gimp-resource-duplicate systemBrush))

; test duplicate is effective, id is a brush
(assert `(gimp-resource-id-is-brush ,duplicatedSystemBrush))

; name of duplicated font is generated by appending " copy" and later "#x"
; This fails on retry if cleanup delete fails
(assert `(string=? (gimp-resource-get-name ,duplicatedSystemBrush)
                   "2. Star copy"))

; can rename a duplicated brush
(assert `(gimp-resource-rename ,duplicatedSystemBrush "NewName"))
; rename is effective
(assert `(string=? (gimp-resource-get-name ,duplicatedSystemBrush)
                   "NewName"))

; can delete a duplicated font
(assert `(gimp-resource-delete ,duplicatedSystemBrush))


(script-fu-use-v2)

